/*
 * Decompiled with CFR 0.152.
 */
package org.zefer.pd4ml.taglib;

import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.util.StringTokenizer;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.zefer.pd4ml.PD4PageMark;
import org.zefer.pd4ml.taglib.PD4FooterTag;
import org.zefer.pd4ml.taglib.PD4HeaderTag;
import org.zefer.pd4ml.taglib.PD4MLTransformerTag;

public class PD4HeaderFooterTag
extends BodyTagSupport {
    private PD4PageMark pageMark = new PD4PageMark();
    private String watermarkBounds;
    private String watermarkUrl;
    private String watermarkOpacity;
    private String pageBackgroundImageUrl;
    private Color pageBackgroundColor;

    public int doStartTag() throws JspException {
        return 2;
    }

    public int doEndTag() throws JspException {
        BodyContent bodyContent;
        Object object;
        if (this.watermarkUrl != null && this.watermarkUrl.trim().length() > 0) {
            int n = 100;
            try {
                n = this.watermarkOpacity == null || this.watermarkOpacity.length() == 0 ? 100 : Integer.parseInt(this.watermarkOpacity);
                n = Math.max(0, n);
                n = Math.min(100, n);
            }
            catch (NumberFormatException numberFormatException) {
                throw new JspTagException("Invalid watermark opacity value: " + this.watermarkOpacity);
            }
            object = null;
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(this.watermarkBounds, ",");
                int n2 = Integer.parseInt(stringTokenizer.nextToken());
                int n3 = Integer.parseInt(stringTokenizer.nextToken());
                int n4 = Integer.parseInt(stringTokenizer.nextToken());
                int n5 = Integer.parseInt(stringTokenizer.nextToken());
                object = new Rectangle(n2, n3, n4, n5);
            }
            catch (Exception exception) {
                throw new JspTagException("Invalid watermark image bounds (x, y, width, height): " + this.watermarkBounds);
            }
            this.pageMark.setWatermark(this.watermarkUrl, (Rectangle)object, n);
        }
        if (this.pageBackgroundColor != null) {
            this.pageMark.setPageBackgroundColor(this.pageBackgroundColor);
        }
        if (this.pageBackgroundImageUrl != null) {
            this.pageMark.setPageBackgroundImageUrl(this.pageBackgroundImageUrl);
        }
        if ((bodyContent = this.getBodyContent()) != null && (object = bodyContent.getString()) != null && ((String)(object = ((String)object).trim())).length() != 0) {
            this.pageMark.setHtmlTemplate((String)object);
        }
        try {
            for (object = this.getParent(); object != null && !(object instanceof PD4MLTransformerTag); object = object.getParent()) {
            }
            if (object != null && object instanceof PD4MLTransformerTag) {
                if (this instanceof PD4HeaderTag) {
                    ((PD4MLTransformerTag)((Object)object)).setHeader(this.pageMark);
                }
                if (this instanceof PD4FooterTag) {
                    ((PD4MLTransformerTag)((Object)object)).setFooter(this.pageMark);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.pageMark = new PD4PageMark();
        return 0;
    }

    public String getAreaHeight() {
        return "" + this.pageMark.getAreaHeight();
    }

    public String getColor() {
        return "" + this.pageMark.getColor().getRGB();
    }

    public String getInitialPageNumber() {
        return "" + this.pageMark.getInitialPageNumber();
    }

    public String getPageNumberAlignment() {
        switch (this.pageMark.getPageNumberAlignment()) {
            case 0: {
                return "left";
            }
            case 1: {
                return "center";
            }
            case 2: {
                return "right";
            }
        }
        return null;
    }

    public String getPageNumberTemplate() {
        return this.pageMark.getPageNumberTemplate();
    }

    public String getPagesToSkip() {
        return "" + this.pageMark.getPagesToSkip();
    }

    public String getTitleAlignment() {
        switch (this.pageMark.getTitleAlignment()) {
            case 0: {
                return "left";
            }
            case 1: {
                return "center";
            }
            case 2: {
                return "right";
            }
        }
        return null;
    }

    public String getTitleTemplate() {
        return this.pageMark.getTitleTemplate();
    }

    public void setAreaHeight(String string) {
        int n = Integer.parseInt(string);
        this.pageMark.setAreaHeight(n);
    }

    public void setColor(String string) {
        Color color = Color.decode(string);
        this.pageMark.setColor(color);
    }

    public void setInitialPageNumber(String string) {
        int n = Integer.parseInt(string);
        this.pageMark.setInitialPageNumber(n);
    }

    public void setPageNumberAlignment(String string) {
        String string2 = string.toLowerCase();
        if (string2.equals("left")) {
            this.pageMark.setPageNumberAlignment(0);
        } else if (string2.equals("center")) {
            this.pageMark.setPageNumberAlignment(1);
        } else if (string2.equals("right")) {
            this.pageMark.setPageNumberAlignment(2);
        }
    }

    public void setPageNumberTemplate(String string) {
        this.pageMark.setPageNumberTemplate(string);
    }

    public void setPagesToSkip(String string) {
        int n = Integer.parseInt(string);
        this.pageMark.setPagesToSkip(n);
    }

    public void setTitleAlignment(String string) {
        String string2 = string.toLowerCase();
        if (string2.equals("left")) {
            this.pageMark.setTitleAlignment(0);
        } else if (string2.equals("center")) {
            this.pageMark.setTitleAlignment(1);
        } else if (string2.equals("right")) {
            this.pageMark.setTitleAlignment(2);
        }
    }

    public void setTitleTemplate(String string) {
        this.pageMark.setTitleTemplate(string);
    }

    public int getFontSize() {
        return this.pageMark.getFontSize();
    }

    public void setFontSize(int n) {
        this.pageMark.setFontSize(n);
    }

    public String getFontFace() {
        return this.pageMark.getFont().getFontName();
    }

    public void setFontFace(String string) {
        Font font = new Font(string, this.pageMark.getFont().getStyle(), this.pageMark.getFontSize());
        this.pageMark.setFont(font);
    }

    public String getFontStyle() {
        switch (this.pageMark.getFont().getStyle()) {
            case 0: {
                return "plain";
            }
            case 2: {
                return "italic";
            }
            case 1: {
                return "bold";
            }
            case 3: {
                return "bolditalic";
            }
        }
        return "plain";
    }

    public void setFontStyle(String string) {
        int n = 0;
        if (string.equalsIgnoreCase("plain")) {
            n = 0;
        } else if (string.equalsIgnoreCase("italic")) {
            n = 2;
        } else if (string.equalsIgnoreCase("bold")) {
            n = 1;
        } else if (string.equalsIgnoreCase("bolditalic")) {
            n = 3;
        }
        Font font = new Font(this.pageMark.getFont().getFontName(), n, this.pageMark.getFontSize());
        this.pageMark.setFont(font);
    }

    public String getWatermarkBounds() {
        return this.watermarkBounds;
    }

    public String getWatermarkOpacity() {
        return this.watermarkOpacity;
    }

    public String getWatermarkUrl() {
        return this.watermarkUrl;
    }

    public void setWatermarkBounds(String string) {
        this.watermarkBounds = string;
    }

    public void setWatermarkOpacity(String string) {
        this.watermarkOpacity = string;
    }

    public void setWatermarkUrl(String string) {
        this.watermarkUrl = string;
    }

    public String getPageBackgroundColor() {
        return "" + this.pageBackgroundColor.getRGB();
    }

    public void setPageBackgroundColor(String string) {
        Color color;
        this.pageBackgroundColor = color = Color.decode(string);
    }

    public String getPageBackgroundImageUrl() {
        return this.pageBackgroundImageUrl;
    }

    public void setPageBackgroundImageUrl(String string) {
        this.pageBackgroundImageUrl = string;
    }
}

